@extends('master')
@section('content')
<div id="wrapper">
   <div id="page-wrapper">
      <div class="col-md-12" id="flash_message">
         @if(Session::has('mail'))
        <div class="alert alert-success alert-dismissable">
          <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
          {{ Session::get('mail') }}
        </div>
         @endif
      </div>
      <div class="container-fluid">
         <div class="white-box">
            <div class="row">
               <div class="col-lg-12 col-md-12 col-sm-12" >
                  <ol class="breadcrumb">
                     <li><a href="{{ URL::to('admin/facilitylist') }}">Home</a></li>
                     <li class="active">Managed Facilities </li>
                  </ol>
                  <div class="well">
                     <form role="search" class="app-search hidden-sm hidden-xs m-r-10">
                        <input type="text" class="pull-right form-control" id="myInput" onkeyup="myFunction()" name="search" placeholder="Search..."><a href=""><i class="fa fa-search"></i></a>
                     </form>
                     <h2>Managed Facilities <span style="color: black; font-size: 12px" >(Showing {{$user_facilities}} entries)</span>
                     </h2>
                     <div class="table-responsive">
                        @if($user_facilities > 0)
                        <table class="table table-fixed table-responsive" id="myTable">
                           <thead class="tabhead">
                              <tr class="header">
                                 <th style="width:10%">Need Help?</th>
                                 <th style="width:10%">FID</th>
                                 <th style="width:35%">Account Name</th>
                                 <th style="width:25%">Address</th>
                                 <th class="centerfa" style="width:10%">USSBOA</th>
                                 <th class="centerfa" style="width:10%">Golars Tank</th>
                              </tr>
                           </thead>
                           <tbody>
                               @foreach ($facilitylist as $data)
                              <?php $addr = $data->BillingAddress->street.','.$data->BillingAddress->city.','.$data->BillingAddress->state.' '.$data->BillingAddress->postalCode.','.$data->BillingAddress->country;?>
                              <tr class="header-one">
                                 <td  style="width:10%">
                                    <a href="{{url('admin/facilitylist_mail_send/' . $data->FID__c)}}" type="button" class="btn btn-success btn-sm" style="background-color:#6EB005; border: 1px solid #6EB005;"><i class="fa fa-envelope-o" aria-hidden="true"> Contact Us</i>
                                    </a>
                                 </td>
                                 <td style="color:#0D91F9;width:10%">
                                    <a href="{{ URL::to('admin/facilityview/' . $data->FID__c) }}" class="text "><?php echo $data->FID__c; ?>
                                    </a>
                                 </td>
                                 <td style="color:#0D91F9;width:35%">
                                    <a href="{{ URL::to('admin/facilityview/'.$data->FID__c)}}" class="text"><?php echo $data->Name; ?>
                                    </a>
                                 </td>
                                 <td style="color:#000000;width:25%" data-toggle="tooltip" data-placement="left" title="{{ $addr }}"> 
                                    <i class="fa fa-map-marker" style="color:#9B9B9B;"></i> {{ str_limit($addr, 25) }}
                                 </td>
                                 @if($data->USSBOA_Paid_Service__c == 1)
                                 <td class="centerfa" style="width:10%">
                                    <a data-target="#" style="color:#E66720;" >
                                    <i class="fa fa-thumbs-o-up fa-2x" data-toggle="tooltip" data-placement="left" title="Paid" aria-hidden="true" style="color: green;">
                                    </i>
                                    </a>
                                 </td>
                                 @else
                                 <td class="centerfa" style="width:10%">
                                    <a href="{{url('admin/addpaymentlist')}}" type="button" class="btn btn-primary btn-sm active" style="background-color:#005097;">
                                    <i class="fa fa-usd" aria-hidden="true">
                                    </i> Pay Now</a>
                                 </td>
                                 @endif
                                 @if($data->MGT_Paid_Service__c == 1)
                                 <td class="centerfa" style="width:10%">
                                    <a data-target="#" style="color:#E66720;" ><i class="fa fa-thumbs-o-up fa-2x" data-toggle="tooltip" data-placement="left" title="Paid" aria-hidden="true" style="color: green;"></i></a>
                                 </td>
                                 @else
                                 <td class="centerfa" style="width:10%">
                                    <a href="{{url('admin/addpaymentlist')}}" type="button" class="btn btn-primary btn-sm cen" style="background-color:#005097;">
                                    <i class="fa fa-usd" aria-hidden="true"></i> Pay Now</a>
                                 </td>
                                 @endif
                              </tr>
                              
                              @endforeach
                           </tbody>
                        </table>
                        @else
                        <table class="table table-fixed table-responsive" id="myTable">
                           <thead class="tabhead">
                              <tr class="header">
                                 <th style="width:10%">Need Help?</th>
                                 <th style="width:10%">FID</th>
                                 <th style="width:35%">Account Name</th>
                                 <th style="width:25%">Address</th>
                                 <th class="centerfa" style="width:10%">USSBOA</th>
                                 <th class="centerfa" style="width:10%">Golars Tank</th>
                              </tr>
                           </thead>
                            <tbody>
                                <tr>
                                    <td>
                                    <h1 class="text-center">No Facility Records Found.</h1>
                                </td>
                                </tr>
                            </tbody>
                           </table>
                        @endif
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<script>
   $(function(){
     $('#myTable').find('thead tr:odd').addClass('odd-color');
      });
</script>
<script>
   $('#flash_message').fadeIn().delay(10000).fadeOut();
</script>
 <script type="text/javascript">
   function myFunction() {
     var input, filter, table, tr, td, i;
     input = document.getElementById("myInput");
     filter = input.value.toUpperCase();
     table = document.getElementById("myTable");
     tr = table.getElementsByTagName("tr");
     for (i = 0; i < tr.length; i++) {
       td = tr[i].getElementsByTagName("td")[1];
       if (td) {
         if (td.innerHTML.toUpperCase().indexOf(filter) > -1) {
           tr[i].style.display = "";
         } else {
           td1 = tr[i].getElementsByTagName("td")[2];
       if (td1) {
         if (td1.innerHTML.toUpperCase().indexOf(filter) > -1) {
           tr[i].style.display = "";
         } else {
          td2 = tr[i].getElementsByTagName("td")[3];
       if (td2) {
         if (td2.innerHTML.toUpperCase().indexOf(filter) > -1) {
           tr[i].style.display = "";
         } else { 
   
           tr[i].style.display = "none";

         }
       }
         }
       }
         }
       }
     }
   }
</script>
@stop

